uniform vec3 Ldir;
uniform mat4 texMat01;
uniform mat4 texMat02;
uniform mat4 texMat03;

uniform mat4 modelMatrix;
uniform mat4 viewMatrix;

varying vec4 projCoordShadow01;
varying vec4 projCoordShadow02;
varying vec4 projCoordShadow03;
varying vec2 coordTex;

varying vec3 lightVec; 
varying vec3 eyeVec;

void main()
{
	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	
    vec3 n = normalize(gl_NormalMatrix * gl_Normal);
    vec3 t = normalize(gl_NormalMatrix * gl_MultiTexCoord6.xyz);
    vec3 b = normalize(gl_NormalMatrix * gl_MultiTexCoord7.xyz);
    mat3 rotmat = mat3(t, b, n);
    
	vec3 vVertex = vec3(gl_ModelViewMatrix * gl_Vertex);
 	vec3 vLdir = vec3(viewMatrix * vec4(Ldir, 1.0));
   
    lightVec =  (vLdir - vVertex) * rotmat;    

    vec3 tmpVec = -vVertex;
    eyeVec = tmpVec * rotmat;

    coordTex = vec2(gl_MultiTexCoord0);
    projCoordShadow01 = texMat01 * (modelMatrix * gl_Vertex);
    projCoordShadow02 = texMat02 * (modelMatrix * gl_Vertex);
    projCoordShadow03 = texMat03 * (modelMatrix * gl_Vertex);
    
}